IF EXISTS(SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Schedule]') AND type in (N'U'))
BEGIN
	IF EXISTS(SELECT 1 FROM sys.columns   WHERE Name = N'ScheduleId'   AND Object_ID = Object_ID(N'[dbo].[Schedule]'))
	BEGIN
		DECLARE @ConstraintToDrop nvarchar(1000)
		DECLARE @SqlQuery nvarchar(1100)
		SET @ConstraintToDrop = ''
		SELECT @ConstraintToDrop = D.Name
			  FROM sys.all_columns c
			  JOIN sys.tables t                   ON  t.object_id = c.object_id
			  JOIN sys.schemas s                  ON  s.schema_id = t.schema_id
			  JOIN sys.default_constraints d      ON  c.default_object_id = d.object_id
			  WHERE t.name = 'Schedule'
			  AND c.name = 'ScheduleId'
			  AND s.name = 'dbo'
			  AND D.Name <> 'DF_Schedule_ScheduleId'

		IF @ConstraintToDrop != ''
		BEGIN
		  SET @SqlQuery = 'ALTER TABLE [dbo].[Schedule] DROP CONSTRAINT ' + @ConstraintToDrop
		  EXECUTE sp_executesql @SqlQuery
		END
	END

	IF NOT EXISTS(SELECT 1 FROM sys.columns   WHERE Name = N'ScheduleId'   AND Object_ID = Object_ID(N'[dbo].[Schedule]'))
	BEGIN
		--Create the New column
		ALTER TABLE  Schedule ADD ScheduleId INT NOT NULL DEFAULT(0)
	END
	ELSE
	BEGIN
	   IF NOT EXISTS (SELECT D.Name FROM sys.all_columns c
			          JOIN sys.tables t                   ON  t.object_id = c.object_id
			          JOIN sys.schemas s                  ON  s.schema_id = t.schema_id
			          JOIN sys.default_constraints d      ON  c.default_object_id = d.object_id
			          WHERE t.name = 'Schedule'
			          AND c.name = 'ScheduleId'
			          AND s.name = 'dbo'
			          AND D.Name = 'DF_Schedule_ScheduleId')
		BEGIN
			ALTER TABLE [dbo].[Schedule] ADD  CONSTRAINT DF_Schedule_ScheduleId  DEFAULT ((0)) FOR [ScheduleId]
			ALTER TABLE [dbo].[Schedule] ALTER COLUMN [ScheduleId] INTEGER NOT NULL
		END
	END
END
GO

IF EXISTS(SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Schedule]') AND type in (N'U'))
BEGIN
	IF (SELECT COUNT(*) FROM [dbo].[Schedule] WHERE ScheduleId is null or ScheduleId = 0) > 0
	BEGIN
		--Populate the new column
        UPDATE Schedule 
        SET scheduleId = s.newScheduleId 
        FROM ( SELECT ScheduleId, 
                            Schedule.SchLabel AS Label,
                            (COALESCE(MAX(ScheduleId) OVER (), 0) +  ROW_NUMBER() OVER (PARTITION BY ScheduleId ORDER BY (SELECT NULL))) as newScheduleId,
                            SchAction,
                            Schtime
                            FROM Schedule 
                            GROUP BY SchLabel ,schaction, schtime, ScheduleId) s
        WHERE s.Label = Schedule.SchLabel and s.SchAction=Schedule.SchAction and s.Schtime=Schedule.Schtime

	END
END
GO